USE [master]
GO

/****** Object:  Database [direct]    Script Date: 03/24/2014 19:01:40 ******/
CREATE DATABASE [direct]

ALTER DATABASE [direct] SET COMPATIBILITY_LEVEL = 100
GO

IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [direct].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO

ALTER DATABASE [direct] SET ANSI_NULL_DEFAULT OFF 
GO

ALTER DATABASE [direct] SET ANSI_NULLS OFF 
GO

ALTER DATABASE [direct] SET ANSI_PADDING OFF 
GO

ALTER DATABASE [direct] SET ANSI_WARNINGS OFF 
GO

ALTER DATABASE [direct] SET ARITHABORT OFF 
GO

ALTER DATABASE [direct] SET AUTO_CLOSE OFF 
GO

ALTER DATABASE [direct] SET AUTO_CREATE_STATISTICS ON 
GO

ALTER DATABASE [direct] SET AUTO_SHRINK OFF 
GO

ALTER DATABASE [direct] SET AUTO_UPDATE_STATISTICS ON 
GO

ALTER DATABASE [direct] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO

ALTER DATABASE [direct] SET CURSOR_DEFAULT  GLOBAL 
GO

ALTER DATABASE [direct] SET CONCAT_NULL_YIELDS_NULL OFF 
GO

ALTER DATABASE [direct] SET NUMERIC_ROUNDABORT OFF 
GO

ALTER DATABASE [direct] SET QUOTED_IDENTIFIER OFF 
GO

ALTER DATABASE [direct] SET RECURSIVE_TRIGGERS OFF 
GO

ALTER DATABASE [direct] SET  DISABLE_BROKER 
GO

ALTER DATABASE [direct] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO

ALTER DATABASE [direct] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO

ALTER DATABASE [direct] SET TRUSTWORTHY OFF 
GO

ALTER DATABASE [direct] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO

ALTER DATABASE [direct] SET PARAMETERIZATION SIMPLE 
GO

ALTER DATABASE [direct] SET READ_COMMITTED_SNAPSHOT OFF 
GO

ALTER DATABASE [direct] SET HONOR_BROKER_PRIORITY OFF 
GO

ALTER DATABASE [direct] SET  READ_WRITE 
GO

ALTER DATABASE [direct] SET RECOVERY FULL 
GO

ALTER DATABASE [direct] SET  MULTI_USER 
GO

ALTER DATABASE [direct] SET PAGE_VERIFY CHECKSUM  
GO

ALTER DATABASE [direct] SET DB_CHAINING OFF 
GO

 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON

 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[users]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[users](
 [user_id] [bigint] IDENTITY(1,1) NOT NULL,
 [user_edipi] [bigint] NULL,
 [user_name] [nvarchar](50) NOT NULL,
 [user_mail] [nvarchar](50) NULL,
 [user_theme] [bigint] NOT NULL,
 [user_ep] [nvarchar](max) NOT NULL,
 [user_created_by] [bigint] NOT NULL,
 [user_created_date] [bigint] NOT NULL,
 [user_ext_notify_flag] [tinyint] NOT NULL,
 [user_ext_group_notify_flag] [tinyint] NOT NULL,
 [user_deleted_flag] [tinyint] NOT NULL,
 [user_locale] [nvarchar](max) NULL,
 [user_is_group] [tinyint] NOT NULL,
 [user_piv_id] [bigint] NULL,
  CONSTRAINT [PK_users2] PRIMARY KEY CLUSTERED ([user_id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY], 
  UNIQUE NONCLUSTERED ([user_name] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
 END
 
USE [direct]
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON

 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[contacts]') AND type in (N'U'))
 BEGIN
 USE [direct]
 CREATE TABLE [dbo].[contacts](
 [contact_id] [bigint] IDENTITY(1,1) NOT NULL,
 [user_id] [bigint] NOT NULL,
 [first_name] [varchar](max) NOT NULL,
 [middle_name] [varchar](max) NULL,
 [last_name] [varchar](max) NULL,
 [organization] [nvarchar](max) NULL,
 [department] [nvarchar](max) NULL,
 [telephone] [nvarchar](50) NULL,
 [mail] [nvarchar](50) NOT NULL,
 [title] [nvarchar](max) NULL,
  CONSTRAINT [PK_contacts] PRIMARY KEY NONCLUSTERED ([contact_id] ASC) 
  WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY])
  ON [PRIMARY]
 END

 SET ANSI_PADDING OFF

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_contacts_users]') AND parent_object_id = OBJECT_ID(N'[dbo].[contacts]'))
 BEGIN
 ALTER TABLE [dbo].[contacts]  WITH CHECK ADD  CONSTRAINT [FK_contacts_users] FOREIGN KEY([user_id])
 REFERENCES [dbo].[users] ([user_id])
 END

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_contacts_users]') AND parent_object_id = OBJECT_ID(N'[dbo].[contacts]'))
 BEGIN
 ALTER TABLE [dbo].[contacts] CHECK CONSTRAINT [FK_contacts_users]
 END

 IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[contacts]') AND name = N'PK_contacts')
 ALTER TABLE [dbo].[contacts] DROP CONSTRAINT [PK_contacts]
 /****** Object:  Index [PK_contacts]    Script Date: 11/15/2013 07:17:11 ******/
 ALTER TABLE [dbo].[contacts] ADD  CONSTRAINT [PK_contacts] PRIMARY KEY NONCLUSTERED 
 ([contact_id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]

 IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[contacts]') AND name = N'IX_contact_user')
 CREATE CLUSTERED INDEX [IX_contact_user] ON [dbo].[contacts] 
 ([user_id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON
 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[distribution_lists]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[distribution_lists](
 [id] [bigint] IDENTITY(1,1) NOT NULL,
 [name] [varchar](max) NOT NULL,
 [description] [varchar](max) NULL,
 [created_by] [bigint] NOT NULL,
 [created_at] [bigint] NOT NULL,
 [modified_at] [bigint] NOT NULL,
 [addresses] [varchar](max) NOT NULL default '',
  CONSTRAINT [PK_distribution_lists] PRIMARY KEY NONCLUSTERED ([id] ASC)
  WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY])
  ON [PRIMARY]
 END
 SET ANSI_PADDING OFF

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_user]') AND parent_object_id = OBJECT_ID(N'[dbo].[distribution_lists]'))
 BEGIN
 ALTER TABLE [dbo].[distribution_lists]  WITH CHECK ADD  CONSTRAINT [FK_user] FOREIGN KEY([created_by])
 REFERENCES [dbo].[users] ([user_id])
 END

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_user]') AND parent_object_id = OBJECT_ID(N'[dbo].[distribution_lists]'))
 BEGIN
 ALTER TABLE [dbo].[distribution_lists] CHECK CONSTRAINT [FK_user]
 END

 IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[distribution_lists]') AND name = N'IX_distribution_lists')
 BEGIN
 CREATE CLUSTERED INDEX [IX_distribution_lists] ON [dbo].[distribution_lists] ([created_by] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
 END
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON
 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[edit_log]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[edit_log](
 [edit_id] [bigint] IDENTITY(1,1) NOT NULL,
 [target_user_id] [bigint] NOT NULL,
 [actor_user_id] [bigint] NOT NULL,
 [edit_action] [text] NOT NULL,
 [edit_datetime] [bigint] NOT NULL,
 CONSTRAINT [PK_edit_log] PRIMARY KEY CLUSTERED ([edit_id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
 END
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON
 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[feedback]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[feedback](
 [feedback_id] [bigint] IDENTITY(1,1) NOT NULL,
 [user_id] [bigint] NOT NULL,
 [feedback_type] [nvarchar](50) NOT NULL,
 [feedback_comments] [text] NOT NULL,
 [feedback_datetime] [bigint] NOT NULL,
 CONSTRAINT [PK_feedback] PRIMARY KEY CLUSTERED ([feedback_id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
 END
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON
 ALTER TABLE users ADD UNIQUE (user_name)
 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[flags]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[flags](
 [id] [bigint] IDENTITY(1,1) NOT NULL,
 [color] [varchar](50) NULL,
 [content] [varchar](max) NULL,
 [mailbox_group] [nvarchar](50) NOT NULL,
 [created_by] [bigint] NOT NULL,
 [modified_by] [bigint] NOT NULL,
 [created_at] [bigint] NOT NULL,
 [modified_at] [bigint] NOT NULL,
 CONSTRAINT [PK_flag] PRIMARY KEY NONCLUSTERED 
 ([id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
 END

 SET ANSI_PADDING OFF

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_created_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[flags]'))
 BEGIN
 ALTER TABLE [dbo].[flags]  WITH CHECK ADD CONSTRAINT [FK_created_by] FOREIGN KEY([created_by])
 REFERENCES [dbo].[users] ([user_id])
 END

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_created_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[flags]'))
 BEGIN
 ALTER TABLE [dbo].[flags] CHECK CONSTRAINT [FK_created_by]
 END

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_modified_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[flags]'))
 BEGIN
 ALTER TABLE [dbo].[flags]  WITH CHECK ADD CONSTRAINT [FK_modified_by] FOREIGN KEY([modified_by])
 REFERENCES [dbo].[users] ([user_id])
 END

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_modified_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[flags]'))
 BEGIN
 ALTER TABLE [dbo].[flags] CHECK CONSTRAINT [FK_modified_by]
 END

 IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[flags]') AND name = N'IX_flags')
 BEGIN
 CREATE CLUSTERED INDEX [IX_flags] ON [dbo].[flags] ([created_by] ASC) 
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
 END
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON

 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[logins]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[logins](
 [id] [bigint] IDENTITY(1,1) NOT NULL,
 [session_id] [nvarchar](50) NULL,
 [username] [varchar](50) NULL,
 [ip_address] [nvarchar](50) NULL,
 [login_time] [bigint] NULL,
 [success] [tinyint] NOT NULL,
 [error_msg] [nvarchar](max) NULL,
  CONSTRAINT [PK_logins] PRIMARY KEY CLUSTERED ([id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
 SET ANSI_PADDING OFF
 END
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON

 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mail_log]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[mail_log](
 [id] [bigint] IDENTITY(1,1) NOT NULL,
 [time] [bigint] NULL,
 [size] [bigint] NULL,
 [sender] [varchar](max) NULL,
 [recipient] [varchar](max) NULL,
 [attachment_types] [nvarchar](max) NULL,
 [success] [tinyint] NOT NULL,
 [inbound_outbound] [tinyint] NOT NULL,
  CONSTRAINT [PK_mail_log] PRIMARY KEY CLUSTERED ([id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
 SET ANSI_PADDING OFF
 END
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON

 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[requests]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[requests](
 [request_id] [bigint] IDENTITY(1,1) NOT NULL,
 [user_name] [nvarchar](max) NOT NULL,
 [user_edipi] [bigint] NULL,
 [request_date] [bigint] NOT NULL,
 [first_name] [varchar](max) NULL,
 [middle_name] [varchar](max) NULL,
 [last_name] [varchar](max) NULL,
 [organization] [nvarchar](max) NULL,
 [department] [nvarchar](max) NULL,
 [telephone] [nvarchar](50) NULL,
 [mail] [nvarchar](max) NOT NULL,
 [title] [nvarchar](max) NULL,
 [approved_flag] [tinyint] NOT NULL,
 [created_flag] [tinyint] NOT NULL,
 [denied_flag] [tinyint] NOT NULL,
 [user_piv_id] [bigint] NULL,
  CONSTRAINT [PK_requests] PRIMARY KEY CLUSTERED ([request_id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
 END
 SET ANSI_PADDING OFF
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON

 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sessions]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[sessions](
 [session_id] [varchar](50) NOT NULL,
 [ip_address] [varchar](50) NOT NULL,
 [user_agent] [varchar](max) NOT NULL,
 [last_activity] [int] NOT NULL,
 [user_data] [text] NULL,
  CONSTRAINT [PK_sessions] PRIMARY KEY CLUSTERED ([session_id] ASC)
  WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
 END
 SET ANSI_PADDING OFF
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON

 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[themes]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[themes](
 [theme_id] [bigint] IDENTITY(1,1) NOT NULL,
 [theme_css_name] [nvarchar](50) NOT NULL,
 [theme_display_name] [text] NOT NULL,
 [theme_preview_bg] [nvarchar](max) NOT NULL,
 [theme_banner_img] [nvarchar](max) NOT NULL,
 [theme_banner_alt_text] [nvarchar](max) NOT NULL,
 [theme_is_default] [tinyint] NULL,
  CONSTRAINT [PK_themes] PRIMARY KEY CLUSTERED ([theme_id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
 SET IDENTITY_INSERT [dbo].[themes] ON
 INSERT [dbo].[themes] ([theme_id], [theme_css_name], [theme_display_name], [theme_preview_bg], [theme_banner_img], [theme_banner_alt_text], [theme_is_default]) VALUES (1, N'va', N'VA direct Project', N'#1174AB', N'banner_va.png', N'VA Direct- Simple, Secure Health Messaging', 1)
 SET IDENTITY_INSERT [dbo].[themes] OFF
 END
 
 USE [direct];
 SET ANSI_NULLS ON
 SET QUOTED_IDENTIFIER ON
 SET ANSI_PADDING ON

 IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[workflow_items]') AND type in (N'U'))
 BEGIN
 CREATE TABLE [dbo].[workflow_items](
 [id] [bigint] IDENTITY(1,1) NOT NULL,
 [mailbox_group] [nvarchar](50) NOT NULL,
 [assigned_to] [bigint],
 [complete] [tinyint] NOT NULL DEFAULT 0,
 [created_by] [bigint] NOT NULL,
 [modified_by] [bigint] NOT NULL,
 [created_at] [bigint] NOT NULL,
 [modified_at] [bigint] NOT NULL,
  CONSTRAINT [PK_workflow_flag] PRIMARY KEY NONCLUSTERED ([id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
 END
 SET ANSI_PADDING OFF

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_workflow_mailbox_group]') AND parent_object_id = OBJECT_ID(N'[dbo].[workflow_items]'))
 BEGIN
 ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_mailbox_group]  
 FOREIGN KEY([mailbox_group])
 REFERENCES [dbo].[users] ([user_name])
 ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_mailbox_group]
 END

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_workflow_assigned_to]') AND parent_object_id = OBJECT_ID(N'[dbo].[workflow_items]'))
 BEGIN
 ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_assigned_to]  
 FOREIGN KEY([assigned_to])
 REFERENCES [dbo].[users] ([user_id])
 ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_assigned_to]
 END
 

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_workflow_created_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[workflow_items]'))
 BEGIN
 ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_created_by]  
 FOREIGN KEY([created_by])
 REFERENCES [dbo].[users] ([user_id])
 ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_created_by]
 END

 IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_workflow_modified_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[workflow_items]'))
 BEGIN
 ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_modified_by] 
 FOREIGN KEY([modified_by])
 REFERENCES [dbo].[users] ([user_id])
 
 ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_modified_by]
 END